<?php

use App\Http\Controllers\Admin\Blog\BlogController;
use App\Http\Controllers\Admin\BookingController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\DestinationController;
use App\Http\Controllers\Admin\Location\CityController;
use App\Http\Controllers\Admin\Location\CountryController;
use App\Http\Controllers\Admin\Location\StateController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\Role\RoleController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;

Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
Route::get('/booking/{booking}', [BookingController::class, 'show'])->name('booking.show');
// Location Routes
Route::prefix('locations')->as('location.')->middleware('can:location-manage')->group(function () {
    Route::resource('country', CountryController::class);
    Route::resource('{country}/state', StateController::class);
    Route::resource('{state}/city', CityController::class);
});
Route::resource('destination', DestinationController::class);
Route::resource('{type}/category', CategoryController::class);
Route::resource('package', PackageController::class);
Route::resource('blog', BlogController::class);
Route::resource('role', RoleController::class);
Route::resource('permision', BlogController::class);
// Application Settings
Route::prefix('settings')->as('settings.')->middleware('can:setting-manage')->group(function () {
    Route::get('theme', [SettingsController::class, 'theme'])->name('theme');
    Route::get('/{settings_name?}', [SettingsController::class, 'index'])->name('index');
    Route::post('smtp-configuration', [SettingsController::class, 'appMail'])->name('smtp');
    Route::get('sitemap-generator', [SettingsController::class, 'sitemapGenerator'])->name('sitemap');
    Route::put('maintenance-mode', [SettingsController::class, 'changeStatusMaintenance'])->name('maintain');

    // Application Information Updates
    Route::post('information', [SettingsController::class, 'appInfoUpdate'])->name('info');
    Route::post('contact', [SettingsController::class, 'appContactUpdate'])->name('contact');
    Route::post('properties', [SettingsController::class, 'appPropertiesUpdate'])->name('properties');
    Route::post('config', [SettingsController::class, 'appConfigUpdate'])->name('config');
    Route::post('logo', [SettingsController::class, 'appLogoUpdate'])->name('logo');

    // Payment Updates
    Route::prefix('payment')->as('payment.')->group(function () {
        Route::post('stripe', [SettingsController::class, 'stripePaymentUpdate'])->name('stripe');
        Route::post('paypal', [SettingsController::class, 'paypalPaymentUpdate'])->name('paypal');
        Route::post('bkash', [SettingsController::class, 'bkashPaymentUpdate'])->name('bkash');
        Route::post('nagad', [SettingsController::class, 'nagadPaymentUpdate'])->name('nagad');
    });

    // Social and Authentication Settings
    Route::post('social-login', [SettingsController::class, 'socialLogin'])->name('social');
    Route::post('auth-settings', [SettingsController::class, 'authSettingsUpdate'])->name('auth-settings');

    // Application Backup
    Route::prefix('backup')->as('backup.')->group(function () {
        Route::post('file', [SettingsController::class, 'backupFiles'])->name('files');
        Route::post('db', [SettingsController::class, 'backupDb'])->name('db');
        Route::post('download/{name}/{ext}', [SettingsController::class, 'downloadBackup'])->name('download');
        Route::post('destroy/{name}/{ext}', [SettingsController::class, 'deleteBackup'])->name('destroy');
    });

    Route::post('home-page', [SettingsController::class, 'homePageCategories'])->name('home.categories');
});
